﻿using System.Windows;
using System.Windows.Controls;

namespace Microscopic_Traffic_Simulator.Views.MainWindowView
{
    /// <summary>
    /// Interaction logic for BottomPanelUserControl.xaml
    /// </summary>
    public partial class BottomPanelUserControl : UserControl
    {
        /// <summary>
        /// Constructor for bottom panel user control.
        /// </summary>
        public BottomPanelUserControl()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Event handler for value change of zoom slider to send new value to canvas to redraw it.
        /// </summary>
        /// <param name="sender">Not used sender reference.</param>
        /// <param name="e">Event args of the event.</param>
        private void zoomSlider_ValueChanged(object sender, RoutedPropertyChangedEventArgs<double> e)
        {
            if (e.NewValue != e.OldValue)
            {
                MainWindow window = (Window.GetWindow(this) as MainWindow);
                if (window != null)
                {                    
                    double pixelsPerMeter = window.canvasUserControl.Zoomer.UpdatePixelsPerMeter((int)e.NewValue, 
                        window.canvasUserControl.topologyCanvas.ActualWidth,
                        window.canvasUserControl.topologyCanvas.ActualHeight);
                    zoomRateSlider.Content = string.Format("{0}x", pixelsPerMeter.ToString("0.###"));
                }                
            }            
        }        
    }
}
